//#-hidden-code
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

import PlaygroundSupport
import Setup
import Canvas
import Scenes
import UIKit
import SpriteKit
import SwansQuest

PlaygroundPage.current.liveView = PlaygroundContext.liveViewController
PlaygroundContext.liveViewController.backgroundImage = #imageLiteral(resourceName: "LiveViewBackground.png")

Canvas.load(customFont: "Songkhla-Regular")

let passages = [
    "Do you seek knowledge and perhaps a little adventure? Well, there is a path not far from here that leads to the entrance of a cave. What lies beyond this entrance is the stuff of legends.",
    
    "Few dare to brave the deep black beyond the cave. Many who try, become lost...never to be found again.",
    
    "But if you make it through, a treasure awaits! Yes, a treasure of true knowledge. If you can reach the palace entrance on the other side of the cave, you’ll be granted an audience with the Swan.",
    
    "The Swan is the keeper of a great knowledge.",
    
    "To have any chance of navigating the passage, you must light the torches inside of the cave. But beware, there’s a catch.\n\nThese are no ordinary torches.",
    
    "They only respond to an ancient magic, called “VoiceOver”.",
    
    "There is a simple spell to enable it. First, you must summon Siri. Then speak the incantation: “Please turn on VoiceOver”.\n\nGo ahead, and try it now.",
    
    "I’ll wait..."
]

var script = Script(passages, success: "Nicely done, you’re a natural.", tryAgain: "Try it again. You must learn to cast the spell, otherwise you’ll become lost like the others.")


let conversation = Conversation(with: .lizard, using: script) {
    // Assessment tests whether voiceover is running.
    if UIAccessibility.isVoiceOverRunning {
        PlaygroundPage.current.assessmentStatus = .pass(message: nil)
        return true
    } else {
        return false
    }
}
conversation.performance = { owner in
    owner.endPerformance()
}

let titleScene = Title()
titleScene.loadingDescription = "Welcome to Swan‘s Quest, a programming adventure where you control the fate of our Hero by solving challenges with code. When you‘re ready to have fun, press the play button to get started."

let hut = Hut()
hut.loadingDescription = "A green turtle, walking on two legs approaches an old stone hut, with smoke billowing from its chimney. This is the home of a magical Lizard, who has mentored many an adventurous traveler. Our Hero seeks knowledge and adventure. The Lizard is very old, and takes their time pulling the door closed."

conversation.loadingDescription = "Let‘s see what the Lizard has to say. Our Hero listens patiently as the old sorcerer starts to speak."

let caveEntrance = CaveEntrance()
caveEntrance.loadingDescription = "Armed with the Lizard‘s warning and casting spell for VoiceOver, our Hero embarks into the mysterious cave. What danger lies ahead? And will our Hero keep their wits in the total darkness? Will you?"

let endTitle = TextScene(says: "The adventure continues\n on the next page...")
endTitle.loadingDescription = "Turn the page to find the answers and see if you have what it takes to make it to the other side."

// Scene Order: Title, Hut, Lizard conversation, CaveEntrance, end
var runner = Runner([ titleScene, hut, conversation, caveEntrance, endTitle ])

runner.start()

//#-end-hidden-code
//#-editable-code
// Touch "Run My Code" to start your quest...



//#-end-editable-code
